package ftp;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;

public class CommandeSTOR extends Commande {
	
	public CommandeSTOR(PrintStream ps, String commandeStr) {
		super(ps, commandeStr);
		this.execute();
	}

	public void execute() {
		
		if (commandeArgs.length == 0)
		{
			ps.println("2 La commande doit contenir l'adresse du fichier à envoyer.");
		}
		else
		{
			
			try
			{

				String pathFileToSend = commandeArgs[0];
				
				File fileToSend = new File(pathFileToSend);
				if (!fileToSend.exists())
				{
					System.out.println("Le fichier rentré n'existe pas.");
										
					return;
				}
				
				Socket socketFile = new Socket("localhost", 12345); // On se connecte au serveur sur le port 12345
				
				// On crée un flux de sortie pour envoyer le fichier
				OutputStream out = socketFile.getOutputStream();
				
				// On crée un flux d'entrée pour lire le fichier à envoyer
				FileInputStream in = new FileInputStream(pathFileToSend);
				
				// On crée un tampon pour lire les données du fichier d'entrée
				byte[] buffer = new byte[1024];
				
				// On lit les données du fichier d'entrée et on les envoie via le flux de sortie
				int bytesRead;
				while ((bytesRead = in.read(buffer)) != -1) {
					out.write(buffer, 0, bytesRead);
				}

				System.out.println("Fichier envoyé !");
				
				// On ferme les flux et la connexion avec le serveur
				in.close();
				out.close();
				socketFile.close();
				
				
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // On écoute sur le port 12345

		}
		
		
		
		/*
		String remoteFile2 = "/test/song.mp3";
        File downloadFile2 = new File("D:/Downloads/song.mp3");
        
        OutputStream outputStream2 = new BufferedOutputStream(new FileOutputStream(downloadFile2));
        InputStream inputStream = ftpClient.retrieveFileStream(remoteFile2);
        
        byte[] bytesArray = new byte[4096];
        int bytesRead = -1;
        
        while ((bytesRead = inputStream.read(bytesArray)) != -1) {
            outputStream2.write(bytesArray, 0, bytesRead);
        }
        */
		
	}

}
